using System;
using System.Data;
using System.Collections;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.BOL
{	
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/28/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// Represents blood bank accession area providing basic functionality for retrieving list of 
	/// blood bank accession areas from VistA and getting accession area information. 
	/// </summary>

	#endregion

	public class BloodBankAccessionArea : IRecognizableByID
	{
		/// <summary>
		/// Standard comparer used to compare accession areas by name.
		/// </summary>
		private class AccessionAreaNameComparer : BusinessObjectPropertyComparerBase
		{
			protected override int CompareProperties( object x, object y )
			{
				return Comparer.DefaultInvariant.Compare( ((BloodBankAccessionArea)x).Name, ((BloodBankAccessionArea)y).Name );
			}
		}

		private readonly int _id;
		private readonly string _name;

		/// <summary>
		/// Creates a new instance of the class from a supplied <see cref="DataRow"/>
		/// </summary>
		/// <param name="dtRow"><see cref="DataRow"/> to fetch object data from.</param>
		protected BloodBankAccessionArea( DataRow dtRow )
		{
			Utility.RequireNonNullColumns( dtRow, DatabaseConstants.VistALinkColumnNames.AccessionAreaId, DatabaseConstants.VistALinkColumnNames.AccessionAreaName );

			_id = StDbNullConvert.ToInt32( dtRow[ DatabaseConstants.VistALinkColumnNames.AccessionAreaId ] );
			_name = StDbNullConvert.ToString( dtRow[ DatabaseConstants.VistALinkColumnNames.AccessionAreaName ] ).Trim();
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/28/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5609"> 
		///		<ExpectedInput>None.</ExpectedInput>
		///		<ExpectedOutput>Integer ID.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5610"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Accession area ID.
		/// </summary>
		public virtual int ID
		{
			get
			{
				return _id;
			}
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/28/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5607"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>Non-null name.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5608"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Accession area name.
		/// </summary>
		public virtual string Name
		{
			get
			{
				return _name;
			}
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/28/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2409"> 
		///		<ExpectedInput>None.</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectSortedHashList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2423"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetAllSortedByName
		/// </summary>
		/// <returns></returns>
		public static BusinessObjectSortedHashList GetAllSortedByName()
		{
			DataTable _dt = DAL.VAL.AccessionAreas.GetBloodBankAccessionAreas();
			BusinessObjectSortedHashList _list = new BusinessObjectSortedHashList( new AccessionAreaNameComparer(), _dt.Rows.Count );

			foreach( DataRow _dr in _dt.Rows )
				_list.Add( new BloodBankAccessionArea( _dr ) );

			return _list;		
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/28/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2425"> 
		///		<ExpectedInput>None.</ExpectedInput>
		///		<ExpectedOutput>ID</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2426"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetObjectID
		/// </summary>
		/// <returns></returns>
		public object GetObjectID()
		{			
			return ID;
		}
	}
}
